/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.management.linksession;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkSession {
    private final HashMap<UUID, String> members = new HashMap();

    protected LinkSession() {
    }

    protected void addOrUpdateMember(@NotNull UUID memberUUID, @Nullable String displayName) {
        String string = displayName = displayName == null ? "null" : displayName;
        if (!this.members.containsKey(memberUUID)) {
            this.members.put(memberUUID, displayName);
        } else {
            this.members.replace(memberUUID, displayName);
        }
    }

    protected void removeMember(@NotNull UUID memberUUID) {
        this.members.remove(memberUUID);
    }

    protected boolean isMember(@NotNull UUID memberUUID) {
        return this.members.get(memberUUID) != null;
    }

    @Nullable
    protected String getMemberDisplayName(@NotNull UUID memberUUID) {
        return this.members.get(memberUUID);
    }

    protected List<UUID> getMembersUUID() {
        return this.members.keySet().stream().collect(Collectors.toList());
    }

    protected List<String> getMembersDisplayNames() {
        return this.members.values().stream().collect(Collectors.toList());
    }

    protected NBTTagCompound writeToNBT() {
        NBTTagCompound data = new NBTTagCompound();
        this.members.forEach((uuid, name) -> data.func_74778_a(uuid.toString(), name));
        return data;
    }

    protected static LinkSession createFromNBT(@NotNull NBTTagCompound in) {
        LinkSession ls = new LinkSession();
        for (String key : in.func_150296_c()) {
            ls.addOrUpdateMember(UUID.fromString(key), in.func_74779_i(key));
        }
        return ls;
    }
}

