/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ScanOnServerMessage
extends AbstractMessage<ScanOnServerMessage, IMessage> {
    private BlockPos from;
    private BlockPos to;
    private String name;
    private boolean saveEntities = true;

    public ScanOnServerMessage() {
    }

    public ScanOnServerMessage(@NotNull BlockPos from, @NotNull BlockPos to, @NotNull String name, boolean saveEntities) {
        this.from = from;
        this.to = to;
        this.name = name;
        this.saveEntities = saveEntities;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.from = BlockPosUtil.readFromByteBuf(buf);
        this.to = BlockPosUtil.readFromByteBuf(buf);
        this.saveEntities = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        BlockPosUtil.writeToByteBuf(buf, this.from);
        BlockPosUtil.writeToByteBuf(buf, this.to);
        buf.writeBoolean(this.saveEntities);
    }

    @Override
    public void messageOnServerThread(ScanOnServerMessage message, EntityPlayerMP player) {
        ItemScanTool.saveStructure(player.func_130014_f_(), message.from, message.to, (EntityPlayer)player, message.name, message.saveEntities);
    }
}

