/*
 * Decompiled with CFR 0.152.
 */
package com.theincgi.autocrafter;

import com.theincgi.autocrafter.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Recipe {
    ItemStack output;
    public NonNullList<ItemOptions> items = NonNullList.func_191197_a((int)9, (Object)ItemOptions.access$000());

    public void setRecipe(IRecipe iRecipe) {
        this.output = iRecipe.func_77571_b();
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemOptions.EMPTY);
        }
        if (iRecipe instanceof ShapedRecipes) {
            ShapedRecipes sr = (ShapedRecipes)iRecipe;
            for (int i = 0; i < sr.field_77574_d.size(); ++i) {
                ItemStack[] s = ((Ingredient)sr.field_77574_d.get(i)).func_193365_a();
                ArrayList<ItemStack> alis = new ArrayList<ItemStack>();
                for (int j = 0; j < s.length; ++j) {
                    alis.add(s[j]);
                }
                this.items.set(this.realIndx(i, sr.field_77576_b, sr.field_77577_c), (Object)new ItemOptions(alis));
            }
        } else if (iRecipe instanceof ShapedOreRecipe) {
            ShapedOreRecipe sor = (ShapedOreRecipe)iRecipe;
            for (int i = 0; i < sor.func_192400_c().size(); ++i) {
                Object o = sor.func_192400_c().get(i);
                if (o == null) {
                    o = ItemStack.field_190927_a;
                }
                if (o instanceof List) {
                    this.items.set(this.realIndx(i, sor.getWidth(), sor.getHeight()), (Object)new ItemOptions((List)o));
                    continue;
                }
                if (o instanceof ItemStack) {
                    ItemStack is = (ItemStack)o;
                    this.items.set(this.realIndx(i, sor.getWidth(), sor.getHeight()), (Object)new ItemOptions(is));
                    continue;
                }
                if (o instanceof OreIngredient) {
                    OreIngredient oreIngredient = (OreIngredient)o;
                    this.items.set(i, (Object)new ItemOptions(oreIngredient));
                    continue;
                }
                if (o instanceof CompoundIngredient) {
                    CompoundIngredient ci = (CompoundIngredient)o;
                    this.items.set(i, (Object)new ItemOptions(ci));
                    continue;
                }
                if (o instanceof Ingredient) {
                    Ingredient ing = (Ingredient)o;
                    this.items.set(i, (Object)new ItemOptions(ing));
                    continue;
                }
                this.output = ItemStack.field_190927_a;
                Utils.log("AutoCrafter: ShapedOreRecipe missing case '" + o.getClass() + "'");
            }
        } else if (iRecipe instanceof ShapelessRecipes) {
            ShapelessRecipes sr = (ShapelessRecipes)iRecipe;
            for (int i = 0; i < sr.field_77579_b.size(); ++i) {
                ArrayList<ItemStack> ios = new ArrayList<ItemStack>();
                ItemStack[] isa = ((Ingredient)sr.field_77579_b.get(i)).func_193365_a();
                for (int j = 0; j < isa.length; ++j) {
                    ios.add(isa[j]);
                }
                this.items.set(i, (Object)new ItemOptions(ios));
            }
        } else if (iRecipe instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe slor = (ShapelessOreRecipe)iRecipe;
            for (int i = 0; i < slor.func_192400_c().size(); ++i) {
                Object o = slor.func_192400_c().get(i);
                if (o == null) {
                    o = ItemStack.field_190927_a;
                }
                if (o instanceof List) {
                    this.items.set(i, (Object)new ItemOptions((List)o));
                    continue;
                }
                if (o instanceof ItemStack) {
                    ItemStack is = (ItemStack)o;
                    this.items.set(i, (Object)new ItemOptions(is));
                    continue;
                }
                if (o instanceof OreIngredient) {
                    OreIngredient oreIngredient = (OreIngredient)o;
                    this.items.set(i, (Object)new ItemOptions(oreIngredient));
                    continue;
                }
                if (o instanceof CompoundIngredient) {
                    CompoundIngredient ci = (CompoundIngredient)o;
                    this.items.set(i, (Object)new ItemOptions(ci));
                    continue;
                }
                if (o instanceof Ingredient) {
                    Ingredient ing = (Ingredient)o;
                    this.items.set(i, (Object)new ItemOptions(ing));
                    continue;
                }
                this.output = ItemStack.field_190927_a;
                Utils.log("AutoCrafter: ShaplessOreRecipe missing case '" + o.getClass() + "'");
            }
        } else {
            this.output = ItemStack.field_190927_a;
            Utils.log("It seems " + iRecipe.getClass().toGenericString() + " isn't a supported recipe type.");
        }
    }

    protected int realIndx(int i, int wid, int hei) {
        int x = i % wid;
        int y = (i - x) / wid;
        return x + y * 3;
    }

    public ItemStack getDisplayItem(int slot) {
        ItemOptions opt = (ItemOptions)this.items.get(slot);
        if (opt.opts.size() == 0) {
            return ItemStack.field_190927_a;
        }
        long mod = System.currentTimeMillis() / 500L % (long)opt.opts.size();
        ItemStack is = (ItemStack)opt.opts.get((int)mod);
        return new ItemStack(is.func_77973_b(), 1, is.func_77952_i() == Short.MAX_VALUE ? (int)mod % Math.max(1, is.func_77958_k()) : is.func_77952_i());
    }

    public boolean matchesRecipe(int slot, ItemStack itemStack) {
        ItemOptions opt = (ItemOptions)this.items.get(slot);
        if (opt.opts.size() == 0 && itemStack.func_190926_b()) {
            return true;
        }
        for (ItemStack i : opt.opts) {
            Item item1 = i.func_77973_b();
            Item item2 = itemStack.func_77973_b();
            if (!Recipe.matches(i, itemStack)) continue;
            return true;
        }
        return false;
    }

    public NBTTagList getNBT() {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)this.getOutput().serializeNBT());
        for (int i = 0; i < this.items.size(); ++i) {
            NBTTagCompound slot = new NBTTagCompound();
            slot.func_74782_a("item", (NBTBase)((ItemOptions)this.items.get(i)).getNBT());
            list.func_74742_a((NBTBase)slot);
        }
        return list;
    }

    public static Recipe fromNBT(NBTTagList tags) {
        Recipe recipe = new Recipe();
        recipe.output = new ItemStack(tags.func_150305_b(0));
        int i = 1;
        while (i < tags.func_74745_c()) {
            NBTTagCompound slot = tags.func_150305_b(i);
            int index = i++;
            ItemOptions opts = ItemOptions.fromNBT(slot.func_150295_c("item", 10));
            recipe.items.set(index - 1, (Object)opts);
        }
        return recipe;
    }

    public void clearRecipe() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemOptions.EMPTY);
        }
        this.output = ItemStack.field_190927_a;
    }

    public String toString() {
        String s = "Recipe:\n";
        for (int i = 0; i < this.items.size(); ++i) {
            ItemOptions opts = (ItemOptions)this.items.get(i);
            s = s + "\ti: " + i + " = {";
            for (int j = 0; j < opts.opts.size(); ++j) {
                s = s + ((ItemStack)opts.opts.get(j)).func_77973_b().getRegistryName().toString() + " : ";
                s = s + ((ItemStack)opts.opts.get(j)).func_77952_i();
                if (j >= opts.opts.size() - 1) continue;
                s = s + ", ";
            }
            s = s + "}";
            if (i == this.items.size() - 1) continue;
            s = s + "\n";
        }
        return s;
    }

    public static boolean matches(ItemStack crafts, ItemStack stack) {
        if (crafts.func_190926_b() && stack.func_190926_b()) {
            return true;
        }
        if (!crafts.func_77973_b().equals(stack.func_77973_b())) {
            return false;
        }
        if (crafts.func_77952_i() == Short.MAX_VALUE || stack.func_77952_i() == Short.MAX_VALUE) {
            return true;
        }
        return crafts.func_77952_i() == stack.func_77952_i();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recipe)) {
            return false;
        }
        Recipe r = (Recipe)obj;
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemOptions)r.items.get(i)).equals(this.items.get(i))) continue;
            return false;
        }
        return true;
    }

    public NonNullList<ItemStack> getLeftovers(NonNullList<ItemStack> inv, int from, int to) {
        NonNullList ret = NonNullList.func_191197_a((int)(to - from), (Object)ItemStack.field_190927_a);
        for (int i = from; i < to; ++i) {
            ret.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)((ItemStack)inv.get(i))));
        }
        return ret;
    }

    public ItemStack getOutput() {
        if (this.output == null) {
            return ItemStack.field_190927_a;
        }
        return this.output.func_77946_l();
    }

    public static class ItemOptions {
        private static final ItemOptions EMPTY = new ItemOptions();
        NonNullList<ItemStack> opts = NonNullList.func_191196_a();

        public ItemOptions() {
        }

        public static ItemOptions fromNBT(NBTTagList tagList) {
            ItemOptions opts = new ItemOptions();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = tagList.func_150305_b(i);
                opts.opts.add((Object)new ItemStack(itemTag));
            }
            return opts;
        }

        public NonNullList<ItemStack> getOpts() {
            return this.opts;
        }

        public ItemOptions(ItemStack[] matching) {
            for (int j = 0; j < matching.length; ++j) {
                this.opts.add((Object)matching[j]);
            }
        }

        public ItemOptions(OreIngredient i) {
            this(i.func_193365_a());
        }

        public ItemOptions(CompoundIngredient ci) {
            this(ci.func_193365_a());
        }

        public ItemOptions(ItemStack itemStack) {
            this.opts.add((Object)itemStack);
        }

        public ItemOptions(NonNullList<ItemStack> opts) {
            this.opts = opts;
        }

        public ItemOptions(List<ItemStack> opts) {
            for (int i = 0; i < opts.size(); ++i) {
                this.opts.add((Object)opts.get(i));
            }
        }

        public ItemOptions(Ingredient ing) {
            for (ItemStack i : ing.func_193365_a()) {
                this.opts.add((Object)i);
            }
        }

        public NBTTagList getNBT() {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.opts.size(); ++i) {
                list.func_74742_a((NBTBase)((ItemStack)this.opts.get(i)).serializeNBT());
            }
            return list;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof ItemOptions) {
                ItemOptions io = (ItemOptions)obj;
                if (io.opts.size() != this.opts.size()) {
                    return false;
                }
                for (int i = 0; i < io.opts.size(); ++i) {
                    boolean found = false;
                    ItemStack lookingFor = (ItemStack)io.opts.get(i);
                    for (int j = 0; j < this.opts.size(); ++j) {
                        if (!Recipe.matches(lookingFor, (ItemStack)this.opts.get(j))) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

